package ibase.communication.whatsApp;

import java.util.List;

/*
 * This is a POJO class used to map the MSG91 inbound message JSON object. 
 * The extracted values are then used for constructing the outbound message.
 */
public class WhatsAppWebhookUpdate {
	
	private String customer_name;
    private String sender;
    private String integrated_number;
    private int company_id;
    private String content_type;
    private String received_at;
    private String replied_message_id; // can be null
    private String message_uuid;
    private String text;
    private List<Contact> contacts;
    private List<Message> messages;
    private String template_name;  // can be null
    private String template_language;  // can be null
    private int direction;
    
    
   

    public String getCustomer_name() {
		return customer_name;
	}

	public void setCustomer_name(String customer_name) {
		this.customer_name = customer_name;
	}

	public String getSender() {
		System.out.println("In WhatsAppWebhookUpdate getSender..");
		return sender;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}

	public String getIntegrated_number() {
		return integrated_number;
	}

	public void setIntegrated_number(String integrated_number) {
		this.integrated_number = integrated_number;
	}

	public int getCompany_id() {
		return company_id;
	}

	public void setCompany_id(int company_id) {
		this.company_id = company_id;
	}

	public String getContent_type() {
		return content_type;
	}

	public void setContent_type(String content_type) {
		this.content_type = content_type;
	}

	public String getReceived_at() {
		return received_at;
	}

	public void setReceived_at(String received_at) {
		this.received_at = received_at;
	}

	public String getReplied_message_id() {
		return replied_message_id;
	}

	public void setReplied_message_id(String replied_message_id) {
		this.replied_message_id = replied_message_id;
	}

	public String getMessage_uuid() {
		return message_uuid;
	}

	public void setMessage_uuid(String message_uuid) {
		this.message_uuid = message_uuid;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public List<Contact> getContacts() {
		return contacts;
	}

	public void setContacts(List<Contact> contacts) {
		this.contacts = contacts;
	}

	public List<Message> getMessages() {
		return messages;
	}

	public void setMessages(List<Message> messages) {
		this.messages = messages;
	}

	public String getTemplate_name() {
		return template_name;
	}

	public void setTemplate_name(String template_name) {
		this.template_name = template_name;
	}

	public String getTemplate_language() {
		return template_language;
	}

	public void setTemplate_language(String template_language) {
		this.template_language = template_language;
	}

	


    public int getDirection() {
		return direction;
	}

	public void setDirection(int direction) {
		this.direction = direction;
	}




	public static class Contact {
    	
    	private Profile profile;
        private String wa_id;
    	
        public Profile getProfile() {
			return profile;
		}
		public void setProfile(Profile profile) {
			this.profile = profile;
		}
		public String getWa_id() {
			return wa_id;
		}
		public void setWa_id(String wa_id) {
			this.wa_id = wa_id;
		}
		
    }

    public static class Profile {
    	
		private String name;

        public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

    }

    public static class Message {
        private String from;
    	private String id;
        private String timestamp;
        private Text text;
        private String type;
        private Context context; // add this field

        
        private ibase.communication.whatsApp.WhatsAppWebhookUpdate.Message.Location location; // you must define this class with latitude, longitude

    
        public ibase.communication.whatsApp.WhatsAppWebhookUpdate.Message.Location getLocation() {
            return location;
        }
        // add getter and setter for context
        public Context getContext() {
            return context;
        }
        public void setContext(Context context) {
            this.context = context;
        }
        
        
        public String getFrom() {
			return from;
		}

		public void setFrom(String from) {
			this.from = from;
		}

		public String getId() {
			return id;
		}

		public void setId(String id) {
			this.id = id;
		}

		public String getTimestamp() {
			return timestamp;
		}

		public void setTimestamp(String timestamp) {
			this.timestamp = timestamp;
		}

		public Text getText() {
			return text;
		}

		public void setText(Text text) {
			this.text = text;
		}

		public String getType() {
			return type;
		}

		public void setType(String type) {
			this.type = type;
		}

	


        public static class Text {
        	
			private String body;

            public String getBody() {
				return body;
			}

			public void setBody(String body) {
				this.body = body;
			}

        }
        
        public static class Context {
        	private String id;
            private String from;
            private QuotedMessage quoted_message;
        	
            public String getId() {
				return id;
			}
			public void setId(String id) {
				this.id = id;
			}
			public String getFrom() {
				return from;
			}
			public void setFrom(String from) {
				this.from = from;
			}
			public QuotedMessage getQuoted_message() {
				return quoted_message;
			}
			public void setQuoted_message(QuotedMessage quoted_message) {
				this.quoted_message = quoted_message;
			}
			

            // getters and setters
        }

        public static class QuotedMessage {
        	private String type;
            private Text text;
        	
            public String getType() {
				return type;
			}
			public void setType(String type) {
				this.type = type;
			}
			public Text getText() {
				return text;
			}
			public void setText(Text text) {
				this.text = text;
			}
		

            // getters and setters
        }
        
        public static class Location {
            private double latitude;
            private double longitude;
            // optionally name, address, etc.

            public double getLatitude() { return latitude; }
            public double getLongitude() { return longitude; }
        }
    }
}

